<?php

namespace App\View\Composers;

use Illuminate\View\View;
use App\Services\MenuManager;

class AdminMenuComposer
{
    protected $menuManager;

    public function __construct(MenuManager $menuManager)
    {
        $this->menuManager = $menuManager;
    }

    /**
     * Bind data to the view.
     */
    public function compose(View $view)
    {
        $categories = $this->menuManager->getCategories();
        $pluginMenuItems = [];

        // Get menu items for each category
        foreach ($categories as $key => $category) {
            $items = $this->menuManager->getCategoryItems($key);
            
            // Filter items based on user permissions
            $accessibleItems = array_filter($items, function($item) {
                return $this->menuManager->canAccessMenuItem($item);
            });
            
            if (!empty($accessibleItems)) {
                $pluginMenuItems[$key] = [
                    'category' => $category,
                    'items' => $accessibleItems
                ];
            }
        }

        $view->with('pluginMenuItems', $pluginMenuItems);
    }
}